/* --COPYRIGHT--,BSD_EX
 * Copyright (c) 2014, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *******************************************************************************
 *
 *                       MSP430 CODE EXAMPLE DISCLAIMER
 *
 * MSP430 code examples are self-contained low-level programs that typically
 * demonstrate a single peripheral function or device feature in a highly
 * concise manner. For this the code may rely on the device's power-on default
 * register values and settings such as the clock configuration and care must
 * be taken when combining code from several examples to avoid potential side
 * effects. Also see www.ti.com/grace for a GUI- and www.ti.com/msp430ware
 * for an API functional library-approach to peripheral configuration.
 *
 * --/COPYRIGHT--*/
/*
 * mcu.h
 *
 *  Created on: May 19, 2020
 *      Author: joovi
 */

#ifndef MSP430I20XX_01_IR_THERMOMETER_H_
#define MSP430I20XX_01_IR_THERMOMETER_H_



/********************************
 * Control signals
 ********************************/

#define PIEZO_PWM_FREQ_HZ           4000
#define PIEZO_BUZZER_PERIOD_MS      1000
#define SHUTDOWN_TIMEOUT_SECONDS    15

#define SD24_SAMPLES_PER_SECOND     100     //Range: 1-1000
#define SD24_NUM_AVERAGE_SAMPLES    25      //Range: 1-50.  Number of samles to average for all channels.  Size of ADC buffers

#define BOOST_TIMEOUT_MS            1000    //
#define VREF_LOW_THRESHOLD_VOLTAGE  50       //max is 1.158
#define VBATT_LOW_THRESHOLD_VOLTAGE 50      //max is 1.158

//Thermopile compensation information
#define S_CONV                  .98     // TESTING, NEEDS TO BE STORED IN FLASH
#define EMISSIVITY_HUMAN_SKIN .99  // Can maybe ignore.  1 is perfect  //todo NOT USED CURRENTLY

//debug
//#define DEBUGGING       1  // comment out to remove debug/development code
//#define DEBUGGING_ANALOG_MEASUREMENT       1  // comment out to remove debug/development code
#define HARDWARE_I2C    1  //TODO Implement  I2C // When defined, Hardware I2C is P1.6, 1.7 and LCD SEG6&7 move to P2.0,,2.1.  if not defined they switch and software I2C is used.


//#define CALIBRATION_DEBUG   1
#ifdef CALIBRATION_DEBUG
#define THERMOPILE_TEST_INPUT       521571  // 1 mV  in the format of SD24 output count
//#define THERMISTOR_TEST_INPUT     4094960 // 1.084715V to simulate 30C ambient
#define THERMISTOR_TEST_INPUT       4332921 // simulate 25C ambient
#define VREF_TEST_INPUT             7244    // not used yet
#endif



/**************************
 * GPIOs
 **************************/
//P1.0-p1.7 = LCD SEGMENTS
#ifdef HARDWARE_I2C
#define SCL_BIT         BIT6    //p1.6
#define SDA_BIT         BIT7    //p1.7
#else
#define SCL_BIT         BIT0    //p2.0
#define SDA_BIT         BIT1    //p2.1
#endif

#define ON_OFF_SIGNAL   BIT2    //p2.2
//p2.3-2.6 = LCD COM LINES
#define BOOST_ENABLE_PIEZO_PWM      BIT7    //p2.7  - DUAL USE PIN

/*******************
 * Timer
 *******************/
#define DCO_FREQ_HZ                 16384000
#define ACLK_FREQ_HZ                   32000
#define SHUTDOWN_TIMEOUT_MS         (SHUTDOWN_TIMEOUT_SECONDS * 1000)       //Time from when ON/OFF is released to shutting off LCD and sleeping: Range 500-60000 (.5s-60s)

/*
 * SD24
 */
#define SD24_SAMPLE_DELAY_MS        (1000 / SD24_SAMPLES_PER_SECOND)
#define BUTTON_VOLTAGE_THRESHOLD    300000      //~.5 V for analong "buttons"

/*
 * Boost Converter/Battery?
 */
#define SD24_COUNT_PER_VOLT     7244000       //24bit ADC = .138044uV per step.  +-1.58v reference  so 1V = 7,244,000
#define VREF_LOW_THRESHOLD      (long)(VREF_LOW_THRESHOLD_VOLTAGE  * SD24_COUNT_PER_VOLT)
#define VBATT_LOW_THRESHOLD     (long)(VBATT_LOW_THRESHOLD_VOLTAGE * SD24_COUNT_PER_VOLT)





#endif /* MSP430I20XX_01_IR_THERMOMETER_H_ */
